#version 330

/*const int SampleCount = 11;
const float samples[11] = float[]( 0.1666667, 0.3333333, 0.5, 0.6666667, 0.8333333, 1.0, 0.8333333, 0.6666667, 0.5, 0.3333333, 0.1666667 );

const vec2 pos[11] = vec2[](
#if _VERTICAL
	vec2(0, -5), vec2(0, -4), vec2(0, -3), vec2(0, -2), vec2(0, -1), vec2(0, 0), vec2(0, 1), vec2(0, 2), vec2(0, 3), vec2(0, 4), vec2(0, 5)
#else
	vec2(-5, 0), vec2(-4, 0), vec2(-3, 0), vec2(-2, 0), vec2(-1, 0), vec2(0, 0), vec2(1, 0), vec2(2, 0), vec2(3, 0), vec2(4, 0), vec2(5, 0)
#endif
);*/

const int SampleCount = 7;
const float samples[7] = float[]( 0.25, 0.5, 0.75, 1.0, 0.75, 0.5, 0.25 );
const vec2 pos[7] = vec2[](
#if _VERTICAL
	vec2(0, -3), vec2(0, -2), vec2(0, -1), vec2(0, 0), vec2(0, 1), vec2(0, 2), vec2(0, 3)
#else
	vec2(-3, 0), vec2(-2, 0), vec2(-1, 0), vec2(0, 0), vec2(1, 0), vec2(2, 0), vec2(3, 0)
#endif
);

uniform sampler2D color0Tex;
uniform sampler2D tex;
uniform vec4 invTexSize;
uniform vec4 span;
uniform float farClip;

#define EXTRA_NICE 0

in vec4 uv;

out vec4 oColor;

void main()
{
	float depth = -textureLod(color0Tex, uv.xy, 0).z*farClip;
	if(depth == 0) depth = 1;
	
	//float blurriness = clamp(pow(depth * 20, 2) - 1, 0.0, 1.0);
	//blurriness = mix(blurriness, 1.0, clamp(2.0 + depth*1000, 0.0, 1.0));
	
	float blurriness = clamp(max(1.0 - (depth - span.x)/(span.y - span.x), (depth - span.z)/(span.w - span.z)), 0.0, 1.0);
	
	vec3 sum = vec3(0);
	vec3 color;
	float luminosity, f, b;
	
	float totF = 0;
	for (int i = 0; i < SampleCount; i++) {
		color = textureLod(tex, uv.xy + pos[i]*blurriness*invTexSize.xy, 0).rgb;
		luminosity = dot(color, vec3(0.299, 0.587, 0.114));
		
		f = samples[i] * (0.1 + luminosity);
		
#ifdef EXTRA_NICE
		depth = textureLod(color0Tex, uv.xy + pos[i]*blurriness*invTexSize.xy, 0).z;
		b = clamp(pow(depth * 20, 2) - 1, 0.25, 1.0);
		b = mix(b, 1.0, clamp(2.0 + depth*1000, 0.0, 1.0));
		f *= b;
#endif
		
		sum += color * f;
		totF += f;
	}
	color = sum/totF;
	oColor = vec4(color, 1.0);
}
